INSERT INTO device_types (id, name) values (1, 'Linux box'), (2, 'Advantech router'), (3, 'OpenWRT box'), (4, 'Teltonika router'), (5, 'CSTECH gateway'), (6, 'SNMP device');

INSERT INTO tunnel_op (id, name) VALUES (0, 'NONE'), (1, 'SETUP'), (2, 'SHUTDOWN'), (3, 'RESTART');

INSERT INTO tunnel_status (id, name, description) VALUES (0, 'Free', 'This tunnel position is free'), (1, 'Waiting for device', 'Tunnel is waiting for device connection.'), (2, 'Ready', 'Tunnel is ready.'), (3, 'Not Available', 'Device disconnected, waiting for reconnect'), (4, 'Shutting down...', 'Stopped on server side, waiting for device-side stop.'), (5, 'Dead', 'Setup or other permanent tunnel error.');

INSERT INTO tunnel_op_status_map (operation_id, status_id) VALUES (1, 0), (1, 5), (2, 1), (2, 2), (2, 3), (2, 5), (3, 3);

INSERT INTO product_flags_license_status (id, description) VALUES
(0, "License OK"),
(1, "License not valid"),
(2, "Too many devices"),
(3, "License not valid, too many devices"),
(4, "License expired"),
(5, "License not valid and expired"),
(6, "License expired, too many devices"),
(7, "License not valid, expired and too many devices"),
(8, "Product version not supported by license."),
(9, "License not valid and version not supported by license."),
(10, "Product version not supported by license and too many devices."),
(11, "License not valid, version not supported by license and too many devices."),
(12, "License is expired and version not supported by license."),
(13, "License is not valid, expired and version not supported by license."),
(14, "License is expired, version not supported by license and too many devices."),
(15, "License not valid, expired, version not supported by license and too many devices.");

INSERT INTO product_flags(id, version, description) VALUES ('user_devchg_version', 0, NULL), ('license_status', 1, 0);

INSERT INTO sms_templates(system, target_any, customizable, advantech_cfg, label, text) VALUES (TRUE, TRUE, TRUE, FALSE, "Arbitrary SMS", NULL);

INSERT INTO sms_templates(system, advantech_cfg, label, text) VALUES
(TRUE, TRUE, "Switch to SIM1", "go online sim1"),
(TRUE, TRUE, "Switch to SIM2", "go online sim2"),
(TRUE, TRUE, "Switch router to online", "go online"),
(TRUE, TRUE, "Switch router to offline", "go offline"),
(TRUE, TRUE, "Set binary output to 0", "set out0=0"),
(TRUE, TRUE, "Set binary output to 1", "set out0=1"),
(TRUE, TRUE, "Set 2nd binary output to 0", "set out1=0"),
(TRUE, TRUE, "Set 2nd binary output to 1", "set out1=1"),
(TRUE, TRUE, "Switch to standard CFG profile", "set profile std"),
(TRUE, TRUE, "Switch to alt1 CFG profile", "set profile alt1"),
(TRUE, TRUE, "Switch to alt2 CFG profile", "set profile alt2"),
(TRUE, TRUE, "Switch to alt3 CFG profile", "set profile alt3"),
(TRUE, TRUE, "Reboot the device", "reboot");

INSERT INTO graph_types(id, description) VALUES (1, "Bars"), (2, "Line");

INSERT INTO graph_type_selections(id, graph_type, base, description) VALUES (1, 1, 0, "Bars with base at 0"), (2, 1, -120, "Bars with base at -120"), (3, 2, 0, "Line");

INSERT INTO device_os_types (id, name, dev_type, directory_name, file_extension) VALUES (1, 'Unknown', NULL, NULL, NULL), (2, 'Generic Linux', NULL, NULL, NULL), (3, 'ICR OS', 2, 'conelos', '.bin'), (4, 'Debian Linux', NULL, NULL, NULL), (5, 'OpenWRT', NULL, NULL, NULL), (6, 'RutOS', 4, 'rutos', '.bin'), (7, 'CSTECH Linux', 5, 'cstech', '.bin');

INSERT INTO device_os_versions (id, os_type, description, keep) VALUES
(1, 3, '6.2.0', TRUE);

INSERT INTO fw_firmware_names (id, fwfname) VALUES (1, '');

INSERT INTO device_models (id, model) VALUES (1, '');

INSERT INTO fw_autoupgrade_policy (id, name) values (1, 'Manage on lastest approved major'), (2, 'Keep major, manage on latest approved minor'), (3, 'Keep major+minor, manage on latest approved patch'), (4, 'Keep on specific version'), (5, 'Do not touch');

INSERT INTO device_os_autoupgrade_policy (id, name) values (1, 'Manage on lastest approved'), (2, 'Keep major, manage on latest approved minor'), (3, 'Keep major+minor, manage on latest approved patch'), (4, 'Keep on specific version'), (5, 'Do not touch');

INSERT INTO typetable_value_types (id, name) VALUES (1, 'int'), (2, 'double'), (3, 'string'), (4, 'bool'), (5, 'IPaddr'), (6, 'Selection'), (7, 'IPv6addr');

INSERT INTO agent_profiles (id, profile_name, system) VALUES (1, 'DEFAULT', TRUE);

INSERT INTO agent_profiles (id, profile_name, system, int_ping, int_regular, int_debug, int_fallback, int_fallback_debug, smallcycles, connfail_tolerance, regprogress, fw_autoupgrade, os_autoupgrade) VALUES
(2, 'FASTEST', TRUE,   4,    60,    4,  60,  20,   1,   0,   1, 1, 1),
(3, 'SLOWEST', TRUE, 600, 86400, 3600, 600, 600, 100, 100, 100, 5, 5);


INSERT INTO liveness_time (id, description) values (1, '5 minutes'), (2, '15 minutes'), (3, '1 hour'), (4, '24 hours'), (5, '>24 hours');

INSERT INTO liveness_misscount (id, description) values (1, '0 missed contacts'), (2, '1 missed contact'), (3, '2-5 missed contacts'), (4, '6-20 missed contacts'), (5, '> 20 missed contacts');

INSERT INTO fw_freshness (id, description) values (1, 'Actual firmware'), (2, '1 patch version back'), (3, 'On last minor (old patch)'), (4, 'On last major (old minor)'), (5, 'Obsolete');

INSERT INTO device_timeskew_time (id, description) values (1, '< 20 seconds'), (2, '< 3 minutes'), (3, '< 1 hour'), (4, '< 1 day'), (5, '> 1 day');

INSERT INTO device_sync_statuses (id, description) values (1, 'Arriving'), (2, 'Processing'), (3, 'Synced'), (4, 'Pending'), (5, 'Error');

INSERT INTO device_stats_device_type_map (id_type, livetime_class, livemiss_class, timeskew, voltage, temperature, sync, uptime, mem_total, mem_avail, processes, root_avail, loadavg1, loadavg5, loadavg15, last_reboot, reboot_counter) values 
(1, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true),
(2, true, true, true,  true,  true,  true, true, true, true, true, true, true, true, true, true, true),
(3, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true),
(4, true, true, false, false, true,  true, true, true, true, true, true, true, true, true, true, true),
(5, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true),
(6, true, true, false, true, true, false, true, true, true, true, false, false, false, false, true, true);

INSERT INTO system_labels (id, label, mass_update, description) values (1, 'review', TRUE, '(Inactive) New device that has to be reviewed.'), (2, 'nogenalerts', FALSE, 'Generic alerts (for All devices mongrp) are not evaluated for this device.'), (3, 'sms', FALSE, 'This device could be used for sending SMS notifications.'), (4, 'anyfwversion', FALSE, '(Inactive) Even non-approved Firmware versions can be installed on this device.');

INSERT INTO monitoring_groups(id, name) values
(1, 'All devices');

-- INSERT INTO monitoring_group_statistics (id, name, mongrp_id) values (1, 'liveness_time', 1), (2, 'liveness_miss_count', 1), (3, 'timeskew_class', 1), (4, 'fw_freshness', 1), (5, 'sync_status', 1);

INSERT INTO typetable_time_units VALUES (1, 'minutes'), (2, 'hours'), (3, 'days'), (4, 'weeks'), (5, 'months'), (6, 'quarters'), (7, 'lifetime');

INSERT INTO device_history_timeslot (id, description, amount, unit) VALUES (1, '5m', 5, 1), (2, '15m', 15, 1), (3, '20m', 20, 1), (4, '1h', 1, 2), (5, '6h', 6, 2), (6, '1d', 1, 3), (7, '1w', 1, 4), (8, '1m', 1, 5), (9, 'Q', 1, 6), (10, 'Lifetime', 1, 7), (11, 'Counter', 0, 1);

INSERT INTO device_history_bit_types (id, description) VALUES (1, 'Average'), (2, 'Running Average');

INSERT INTO device_history_types (id, visible_dataparts, description) VALUES (1, 25, 'Default history type'), (2, 4, 'Default small history type');

INSERT INTO device_history_type_map (visible, history_type, bit_type, timeslot, bit_order) VALUES
-- default history stats
(true, 1, 1, 1, 1), --  average last 5m value
(true, 1, 1, 1, 2), --  average older 5m value
(true, 1, 2, 1, 3), --  running average 5m (over 15 m)
(true, 1, 1, 2, 4), --  average +15m value
(true, 1, 1, 2, 5), --  average +15m value
(true, 1, 1, 2, 6), --  average +15m value
(true, 1, 2, 2, 7), --  running average 15m over 1 h
(true, 1, 1, 4, 8), --  average +1h value
(true, 1, 1, 4, 9), --  average +1h value
(true, 1, 1, 4, 10), -- average +1h value
(true, 1, 1, 4, 11), -- average +1h value
(true, 1, 1, 4, 12), -- average +1h value
(true, 1, 2, 4, 13), -- running average 1h (over 6h)
(true, 1, 1, 5, 14), -- average +6h value
(true, 1, 1, 5, 15), -- average +6h value
(true, 1, 1, 5, 16), -- average +6h value
(true, 1, 2, 5, 17), -- running average 6h (over 1 day)
(true, 1, 1, 6, 18), -- average +1d value
(true, 1, 1, 6, 19), -- average +1d value
(true, 1, 1, 6, 20), -- average +1d value
(true, 1, 1, 6, 21), -- average +1d value
(true, 1, 1, 6, 22), -- average +1d value
(true, 1, 1, 6, 23), -- average +1d value
(true, 1, 2, 6, 24), -- running average 1d (over 1 week)
(true, 1, 1, 7, 25), -- average +1w value
(true, 1, 1, 7, 26), -- average +1w value
(true, 1, 1, 7, 27), -- average +1w value
(true, 1, 2, 7, 28), -- running average 1w over 1 month
(true, 1, 1, 8, 29), -- average +1m value
(true, 1, 1, 8, 30), -- average +1m value
(true, 1, 2, 8, 31), -- running average 1m over 1q
(true, 1, 2, 9, 32), -- average +1q value
(true, 1, 2, 9, 33), -- running average Q value - lifetime
-- default running values stuff
(true, 2, 2, 4, 1), -- running hourly average (last hour)
(false, 2, 2, 11, 2), -- counter of (5 min) samples in running hourly average
(true, 2, 2, 6, 3), -- running daily average
(false, 2, 2, 11, 4), -- counter of (hourly) samples in running daily average
(true, 2, 2, 8, 5), -- running monthly average
(false, 2, 2, 11, 6), -- counter of (daily) samples in running monthly average
(true, 2, 2, 10, 7), -- running lifetime average
(false, 2, 2, 11, 8) -- counter of (monthly) samples in running lifetime average
;

INSERT INTO device_history_value_descriptions (id, description, primary_value_type, history_type, usual_min, usual_max, unit, default_ui_order, default_visibility, default_graph_type_selection, actual_graph_type_selection) VALUES
( 1, 'Voltage'           , 2, 1,    0,         48,     'V',  3,  TRUE, 1, 1),
( 2, 'Temperature'       , 2, 1,   10,         50,     'C',  2,  TRUE, 1, 1),
( 3, 'Available memory'  , 1, 1, 8000,    8000000,   'KiB',  7,  TRUE, 1, 1),
( 4, 'Processes'         , 1, 1,   10,        100,     '#',  8,  TRUE, 1, 1),
( 5, 'Root FS free space', 1, 1,    0, 1000000000,   'KiB',  9,  TRUE, 1, 1),
( 6, 'Boot counter'      , 1, 1,    1,        100,     '#', 10, FALSE, 1, 1),
( 7, 'Availability'      , 2, 1,    0,        100,     '%',  1,  TRUE, 1, 1),
( 8, 'Incoming traffic'  , 1, 1,    0,    1000000, 'Bytes',  5,  TRUE, 1, 1),
( 9, 'Outgoing traffic'  , 1, 1,    0,    1000000, 'Bytes',  6,  TRUE, 1, 1),
(10, 'Signal strength'   , 1, 1, -120,          0,   'dBm',  4,  TRUE, 3, 3);

INSERT INTO log_event_source (id, name) VALUES (1, "Daemon"), (2, "WebUI"), (3, "Scripts");

INSERT INTO log_event_type (id, source, name) VALUES
(1, 1, 'Start'),
(2, 1, 'Critical error (daemon)'),
(3, 1, 'Shutting down'),
(4, 1, 'New device connected'),
(5, 1, 'New FW available'),
(6, 1, 'User-defined alert'),
(7, 1, 'General notice'),
(8, 1, 'Licensing issue'),
(9, 1, 'Performing upgrade'),
(10, 1, 'Eventsync (daemon)'),
(11, 1, 'Device autoprofile update'),
(12, 1, 'Tunnel status update'),
(13, 1, 'FW deletion - download ERR'),
(14, 1, 'Device deletion'),
(51, 1, 'Daemon specific event 1'),
(101, 2, 'User login'),
(102, 2, 'Critical error (WebUI)'),
(103, 2, 'Restart requested'),
(104, 2, 'Device CFG user-update'),
(105, 2, 'New FW version requested'),
(106, 2, 'Alert config update'),
(107, 2, 'General notice'),
(108, 2, 'License uploaded'),
(109, 2, 'Upgrade pkg uploaded'),
(110, 2, 'Eventsync (UI)'),
(111, 2, 'Profile update'),
(112, 2, 'Tunnel CFG update'),
(113, 2, 'FW deletion user request'),
(114, 2, 'FW file uploaded'),
(151, 2, 'Monitoring group update'),
(152, 2, 'CFG group update'),
(301, 3, 'Script'),
(302, 3, 'Critical error (script)'),
(303, 3, 'Recycling requested'),
(304, 3, 'Agent CFG update'),
(305, 3, 'Firmware was downloaded'),
(306, 3, 'Unused'),
(307, 3, 'General notice'),
(308, 3, 'License exchanged'),
(309, 3, 'Product upgrade'),
(310, 3, 'Unused'),
(311, 3, 'Unused'),
(312, 3, 'Tunnel prepared'),
(351, 3, 'Notification cannot be sent.'),
(352, 3, 'Backup was performed.'),
(353, 3, 'Restore operation was performed.');

INSERT INTO typetable_operators (id, name, oper_txt, oper_txt2, oper_txt3, operands) VALUES (0, 'non-op' , NULL, NULL, NULL, 0), (1, 'equal', '=', NULL, NULL, 1), (2, 'not equal', '!=', NULL, NULL, 1), (3, 'less than', '<', NULL, NULL, 1), (4, 'less than or equal', '<=', NULL, NULL, 1), (5, 'greater than', '>', NULL, NULL, 1), (6, 'greater than or equal', '>=', NULL, NULL, 1), (7, 'in between', '>', 'AND', '<', 2), (8, 'in between inclusive', '>=', 'AND', '<=', 2), (9, 'outside of', '<', 'OR', '>', 2);

INSERT INTO alert_target_type (id, name) VALUES
(0, 'Invalid target'),
(1, 'Device'),
-- (2, 'Group'), -- planned when group gains specific (non-device) properties
(4, 'at least # devs in grp');

INSERT INTO data_atom_nature (id, name) VALUES (1, 'reported value'), (2, 'desired value'), (3, 'computed value'), (4, 'configuration value'), (5, 'status value'), (6, 'action result');

INSERT INTO data_atom_context (id, name) VALUES (1, 'device'), (2, 'agent'), (3, 'profile'), (4, 'firmware'), (5, 'webtunnel'), (6, 'sshtunnel'), (7, 'server');

INSERT INTO data_atom (id, name, internal_type, nature, context, visible, log_stream, log_db, log_file) VALUES
(1, 'Selected SIM card', 3, 1, 1, 1, True, True, True),
(2, 'Temperature', 2, 1, 1, 1, True, True, True),
(3, 'Allocable memory', 1, 1, 1, 0, True, False, False),
(4, 'RootFS free space', 1, 1, 1, 0, True, False, False),
(5, 'Reboot counter', 1, 3, 1, 1, True, True, True),
(6, 'Firmware version', 3, 1, 1, 1, True, True, True),
(7, 'Agent version', 3, 1, 2, 1, True, True, True),
(8, 'Synchronization status', 1, 5, 1, 0, True, True, False),
(9, 'Signal Strength', 1, 1, 1, 1, True, False, False);

INSERT INTO data_change_source (id, name) VALUES (1, 'server'), (2, 'script'), (3, 'device'), (4, 'user');

INSERT INTO alert_table_selection (id, table_selection) VALUES (0, 'invalid'), (1, 'device_sync_statuses'), (2, 'liveness_time'), (3, 'liveness_misscount'), (4, 'device_os_versions');

INSERT INTO alert_target_spec (id, name, valtype, seltype, hint, custom) VALUES
(0, 'Invalid target', 1, 0, '', FALSE),
(1, 'SYNC status', 6, 1, 'Recommended operators: =, !=', FALSE),
(2, 'Data age', 6, 2, 'Recommended operators: =, >', FALSE),
(3, 'Missed contacts', 6, 3, 'Recommended operators: =, >', FALSE),
(4, 'Input Voltage', 2, 0, 'Recommended to use with voltage interval', FALSE),
(5, 'Device Temperature', 2, 0, 'Recommended to use with temperature interval', FALSE),
(6, 'FW version', 6, 4, 'Recommended operators: =, !=', FALSE),
(7, 'Allocable memory', 1, 0, 'Includes both free and cache memory, use < operator', FALSE),
(8, '# of running processes', 1, 0, 'Highly fluctuable value', FALSE),
(9, 'Root FS free space', 1, 0, 'In kilobytes, 0 = device root FS full', FALSE),
(10, 'AVG load 1 minute', 2, 0, '60-second load. Note data sampling may be > 1 minute', FALSE),
(11, 'AVG load 5 minutes', 2, 0, 'Last 5 minutes load', FALSE),
(12, 'AVG load 15 minutes', 2, 0, 'Last 15 minutes load', FALSE),
(13, 'New reboots', 1, 0, 'Use > 0 to get alerted on every reboot', FALSE),
(14, 'Signal strenght', 1, 0, 'Recommended operators: =, <, >', FALSE),
(15, 'Signal quality', 1, 0, 'Recommended operators: =, <, >', FALSE),
(16, 'Custom number 1', 1, 0, 'Custom integer number 1', TRUE),
(17, 'Custom number 2', 1, 0, 'Custom integer number 2', TRUE),
(18, 'Custom number 3', 1, 0, 'Custom integer number 3', TRUE),
(19, 'Custom number 4', 1, 0, 'Custom integer number 4', TRUE),
(20, 'Custom number 5', 1, 0, 'Custom integer number 5', TRUE),
(21, 'Custom number 6', 1, 0, 'Custom integer number 6', TRUE),
(22, 'Custom number 7', 1, 0, 'Custom integer number 7', TRUE),
(23, 'Custom number 8', 1, 0, 'Custom integer number 8', TRUE),
(24, 'Custom number 9', 1, 0, 'Custom integer number 9', TRUE),
(25, 'Custom real 1', 2, 0, 'Custom real number 1', TRUE),
(26, 'Custom real 2', 2, 0, 'Custom real number 2', TRUE),
(27, 'Custom real 3', 2, 0, 'Custom real number 3', TRUE),
(28, 'Custom real 4', 2, 0, 'Custom real number 4', TRUE),
(29, 'Custom real 5', 2, 0, 'Custom real number 5', TRUE),
(30, 'Custom real 6', 2, 0, 'Custom real number 6', TRUE),
(31, 'Custom real 7', 2, 0, 'Custom real number 7', TRUE),
(32, 'Custom real 8', 2, 0, 'Custom real number 8', TRUE),
(33, 'Custom real 9', 2, 0, 'Custom real number 9', TRUE);

-- (1, 'int'), (2, 'double'), (3, 'string'),

INSERT INTO alert_target_map (target_spec, target_type) VALUES (0, 0), (1, 4), (2, 1), (2, 4), (3, 1), (3, 4), (4, 1), (4, 4), (5, 1), (5, 4), (6, 1), (6, 4), (7, 1), (7, 4), (8, 1), (8, 4), (9, 1), (9, 4), (10, 1), (10, 4), (11, 1), (11, 4), (12, 1), (12, 4), (13, 1), (13, 4), (14, 1), (14, 4), (15, 1), (15, 4), (16, 1), (16, 4), (17, 1), (17, 4), (18, 1), (18, 4), (19, 1), (19, 4), (20, 1), (20, 4), (21, 1), (21, 4), (22, 1), (22, 4), (23, 1), (23, 4), (24, 1), (24, 4), (25, 1), (25, 4), (26, 1), (26, 4), (27, 1), (27, 4), (28, 1), (28, 4), (29, 1), (29, 4), (30, 1), (30, 4), (31, 1), (31, 4), (32, 1), (32, 4), (33, 1), (33, 4);

INSERT INTO product_conf (name, system, valtype, intval, floatval, strval) VALUES
('ExternalURL', false, 3, 0, 0, '127.0.0.1'),
('DB version', true, 1, 1, 0, 0),
('ServiceCoreName', true, 3, 0, 0, 'dwarfg'),
('SysctlPath', true, 3, 0, 0, '/bin/systemctl'),
('ProductRootDir', true, 3, 0, 0, '/opt/dwarfg'),
('ProductSrvDir', true, 3, 0, 0, '/srv/dwarfg'),
('SAASMode', true, 4, false, 0, ''),
('LocalPort', true, 1, 8484, NULL, NULL),
('AggregatedLogsFile', true, 3, 0, 0, 'dwarfg_logspack.tgz'),
('isFirstRun', false, 4, 1, NULL, NULL),
('DevicesTableColumns', false, 3, NULL, NULL, NULL),
('SupportLink', true, 3, 0, 0, 'https://dwarfg.dwarftech.cz/support'),
('SNMPGatewayThreads', true, 1, 1, NULL, NULL),
('SNMPGatewayLoglevel', true, 1, 20, NULL, NULL),
('SNMPGatewayBatch', true, 1, 16, NULL, NULL),
('SNMPGatewayTimeout', true, 1, 4, NULL, NULL),
('SNMPGatewayRetries', true, 1, 2, NULL, NULL),
('SNMPGatewayInterval', true, 1, 240, NULL, NULL),
('SNMPSSLOverride', true, 1, 0, NULL, NULL),
('ServiceSNMPGatewayName', true, 3, 0, 0, 'dwarfg_snmp_gw');
