<?php

namespace App\DataTable;

use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class MonitoringGroupsDatatable
 * @package App\Datatables
 */
class MonitoringGroupDatatable extends BaseDatatable
{

    protected string $entity = \App\Entity\MonitoringGroup\MonitoringGroup::class;
    protected string $name = 'mongrp_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/monitoringGroup/addGroup.js.twig',
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addGroup',
                        'text' => '<i class=\"fa fa-plus\"></i> Add Group',
                    ),
                    $this->getRefreshButton()
                ),
            )
            ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('name', Column::class, array(
                'title' => 'Name',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                if(true === $this->isAdmin() && $row['id'] !== 1) {
                                return true;
                                };
                            }

                            return false;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))
            ->add('Devices_count', Column::class, array(
                'title' => 'Devices count',
                'width' => '100%;',
                'dql' => '(SELECT COUNT({p}) FROM App:MonitoringGroup\MonitoringGroupMapping {p} 
                JOIN App:Device\Device d with {p}.device = d.id
                WHERE {p}.monitoringGroup = monitoringgroup.id AND d.deleted = 0)',
                'searchable' => false,
                'orderable' => true,
            ))

            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.title'),
                'width' => '100%;',
                'actions' => array(
                    array(
                        'route' => 'mntgrp_detail',
                        'route_parameters' => array(
                            'monitoringGroupId' => 'id',
                        ),
                        'label' => $this->translator->trans('sg.datatables.actions.detail'),
                        'icon' => self::ICON_DETAIL,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.detail'),
                            'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                            'role' => 'button',
                        ),
                        'start_html' => '<div class="input-group">',
                    ),
                    array(
                        'route' => 'ajax_monitoring_group_delete',
                        'route_parameters' => array(
                            'monitoringGroupId' => 'id',
                        ),
                        'label' => $this->translator->trans('sg.datatables.actions.delete'),
                        'icon' => self::ICON_DELETE,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.delete'),
                            'class' => 'btn btn-danger btn-xs mb-1',
                            'role' => 'button',
                            'data-toggle' => 'modal',
                            'id' => 'delete',
                            'data-target' => "#confirm-delete",
                        ),
                        'render_if' => function ($row) {
                            return $row['id'] !== 1 && $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },
                        'end_html' => '</div>',

                    ),

                ),
            ))
        ;
    }

}