<?php

declare(strict_types=1);

namespace App\Controller\Admin\Ajax;

use App\DataTable\DeviceDatatable;
use App\Service\ConfigurationService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/admin/ajax/settings', name: 'ajax_settings_')]
class SettingsController extends Controller
{

    /**
     * Set device table columns
     * @return Response
     */
    #[Route(path: '/device-table-columns', name: 'device_table_columns', methods: ['POST'])]
    public function createLabelAction(Request $request, ConfigurationService $configurationService): Response {

        if (!$request->isXmlHttpRequest()) {

            return new Response('Bad request.', 400);

        }

        if (isset($request->request)) {

            $columns = (array)$request->get('columns');
            //$availableColumns = DeviceDatatable::availableColumns;

            $toSave = [];

            foreach ($columns as $column){

                //$toSave[] = $availableColumns[$column];
                $toSave[] = $column;

            }

            if(empty($toSave)){
                $toSave = DeviceDatatable::showColumns;
            }

            $configurationService->setDeviceTableColumns($toSave);

                return new JsonResponse([
                    'code' => 200,
                    'message' => 'success',
                ],200);


        }

        return new JsonResponse([
            'code' => 400,
            'message' => 'error',
            ],400);
    }

}