<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use App\Entity\Device;
use App\Entity\DeviceOsVersion;
use App\Entity\FwFileName;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_profiles')]
#[ORM\Entity]
class ConfigProfile
    {
    /**
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: true)]
    public string $name;

    /**
     * @var Device
     */
    #[ORM\OneToOne(targetEntity: \App\Entity\Device::class, inversedBy: 'configProfileAutomatic', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'automatic', referencedColumnName: 'id_device', nullable: true)]
    public Device $automatic;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', nullable: false, options: ['default' => false])]
    public bool $defaults;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', nullable: false, options: ['default' => true])]
    public bool $directive;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Device", inversedBy="master")
     * @ORM\JoinColumn(name="master", referencedColumnName="id_device")
     */
    //public $master;
    /**
     * @var DeviceOsVersion
     */
    #[ORM\ManyToOne(targetEntity: DeviceOsVersion::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'os_version', referencedColumnName: 'id')]
    public DeviceOsVersion $osVersion;

    /**
     * @var FwFileName
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\FwFileName::class, inversedBy: 'configProfiles')]
    #[ORM\JoinColumn(name: 'fwfname', referencedColumnName: 'id')]
    public FwFileName $fwfname;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Device::class, mappedBy: 'configProfile', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $devices;

    /**
     * ConfigProfile constructor
     */
    public function __construct(){

       $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): ?string {

        return $this->name;

    }

    /**
     * @return Device
     */
    public function getAutomatic(): ?Device {

        return $this->automatic;

    }

}