<?php

declare(strict_types=1);

namespace App\Entity\EventLog;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'log_events')]
#[ORM\Entity]
class EventLog
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var EventType
     */
    #[ORM\ManyToOne(targetEntity: 'EventType', inversedBy: 'events')]
    #[ORM\JoinColumn(name: 'evtype')]
    public EventType $eventType;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public int $value;

    #[ORM\ManyToOne(targetEntity: EventSource::class, inversedBy: 'events')]
    #[ORM\JoinColumn(name: 'source')]
    public EventSource $source;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer', nullable: true)]
    public ?int $extraId;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false)]
    public ?string $msg;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'time', type: 'datetime', options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $time;

    /**
     * EventLog constructor.
     */
    public function __construct()
    {
        $this->time = new \DateTime();
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return EventType
     */
    public function getEventType(): EventType
    {
        return $this->eventType;
    }

    public function setEventType(EventType $eventType): void
    {
        $this->eventType = $eventType;
    }

    /**
     * @return int
     */
    public function getValue(): int
    {
        return $this->value;
    }

    public function setValue(int $value): void
    {
        $this->value = $value;
    }

    /**
     * @return EventSource
     */
    public function getSource(): EventSource
    {
        return $this->source;
    }

    public function setSource(EventSource $source): void
    {
        $this->source = $source;
    }

    /**
     * @return int|null
     */
    public function getExtraId(): ?int
    {
        return $this->extraId;
    }

    public function setExtraId(?int $extraId): void
    {
        $this->extraId = $extraId;
    }

    /**
     * @return string|null
     */
    public function getMsg(): ?string
    {
        return $this->msg;
    }

    public function setMsg(?string $msg): void
    {
        $this->msg = $msg;
    }
}
