<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DeleteType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $text = $options['data']['text'];

        $builder
            ->add('delete', SubmitType::class, [
                'label' => '<i class="fas fa-trash"></i> ' . $text,
                'label_html' => true,
                'block_prefix' => 'modal_footer', 'attr' => ['class' => 'btn btn-danger'],])
        ;

    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}