<?php

namespace Unique\UserBundle\Listener;

use Doctrine\ORM\EntityManagerInterface;
use Unique\UserBundle\Model\UserInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\Security\Http\SecurityEvents;

/**
 * Listener set to user defined Language.
 *
 * @author Lukas Krchnak <lukas.krchnak@uniqueweb.cz>
 */
class LoginListener implements EventSubscriberInterface
{

    private EntityManagerInterface $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {

        $this->entityManager = $entityManager;

    }

    /**
     * On Login Event.
     */
    public function onLogin(InteractiveLoginEvent $event): void
    {
        // Get User
        $user = $event->getAuthenticationToken()->getUser();

        if ($user instanceof UserInterface) {
            // Change Site Language to User
            if ($user->getLanguage()) {
                $event->getRequest()->getSession()->set('_locale', $user->getLanguage());
            }

            // Set Last Login
            $user->setLastLogin(new \DateTime());

            // Save
            $this->entityManager->persist($user);
            $this->entityManager->flush();
        }
    }

    public static function getSubscribedEvents(): array
    {
        return [
            SecurityEvents::INTERACTIVE_LOGIN => 'onLogin',
        ];
    }
}
