<?php

namespace App\Form;

use App\Entity\DeviceOsType;
use App\Entity\DeviceOsVersion;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class FwType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        /** @var DeviceOsType $osTypes */
        $osTypes = $options['data']['osTypes'];

        $choices = [];

        foreach ($osTypes as $osType) {

            $choices[$osType->getName()] = $osType->getId();

        }

        $builder->add('os_type', ChoiceType::class ,array(
            //'data_class' => 'App\Entity\OsType',
            'block_prefix' => 'modal_body',
            'choices' => $choices,
            //'data' => (!is_null($device->getOsVer())) ? $device->getOsVer()->getId() : null,

            //'empty_data' => 'John Doe',
            //'choice_label' => 'version',
            //'choice_value' => 'id',
            // used to render a select box, check boxes or radios
            // 'multiple' => true,
            // 'expanded' => true,
        ))
            ->add('version', TextType::class, ['block_prefix' => 'modal_body'])
            ->add('save', SubmitType::class, ['label' => 'Add Firmware',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver){

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}