<?php

declare(strict_types=1);

namespace App\Entity\MonitoringGroup;

use App\Entity\Alert\Alert;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'monitoring_groups')]
#[ORM\Entity]
class MonitoringGroup
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'monitoringGroup', targetEntity: MonitoringGroupMapping::class, cascade: ['persist', 'remove'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $monitoringGroupMappings;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'targetMonitoringGroup', targetEntity: Alert::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $alerts;

    /**
     * MonitoringGroup constructor.
     */
    public function __construct(){

        $this->monitoringGroupMappings = new ArrayCollection();
        $this->alerts = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): ?string {

        return $this->name;

    }

    /**
     * @return ArrayCollection
     */
    public function getMonitoringGroupMappings(): ArrayCollection {

        return $this->monitoringGroupMappings;

    }

    /**
     * @return ArrayCollection
     */
    public function getAlerts(): ArrayCollection {

        return $this->alerts;

    }

}