<?php

namespace App\Controller\Admin\Tools;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\DataTable\SnmpDatatable;
use App\Form\Snmp\SnmpDeviceType;
use App\Service\EnvConfigurationService;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/tools', name: 'admin_tool_')]
class SnmpGatewayController extends BaseController
{
    /**
     * @param Request $request
     * @param DatatableFactory $factory
     * @param DatatableResponse $responseService
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/snmp', name: 'snmp_index')]
    public function customLabels(
        EnvConfigurationService $envConfigurationService,
        Request $request,
        DatatableFactory $factory,
        DatatableResponse $responseService
    ): Response {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $datatable = $factory->create(SnmpDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        $form = $this->createForm(SnmpDeviceType::class);
        $isServiceEnabled = $envConfigurationService->isPythonComponentsInstalled();

        return $this->render('tool/snmpGateway/index.html.twig', [
            'isServiceEnabled' => $isServiceEnabled,
            'datatable' => $datatable,
            'filter' => $this->filter,
            'form' => $form->createView()
            ]);
    }

}
