<?php

namespace App\Validator\Constraints;

use Symfony\Component\Validator\Constraint;

#[\Attribute] class IsUniqueInDb extends Constraint
{
    public string $message = 'The value is not true for me.';

    public string $name;

    public mixed $options;

    public function __construct(string $name, mixed $options = null, string $message, ?array $groups = null, mixed $payload = null)
    {
        parent::__construct($options, $groups, $payload);
        $this->name = $name;
        $this->message = $message;
        $this->options = $options;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getOptions(): mixed
    {
        return $this->options;
    }
    public function getDefaultOption(): ?string
    {
        return 'options';
    }

    public function getRequiredOptions(): array
    {
        return [];
    }

}