<?php

namespace App\Controller\Admin;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Datatables\CustomLabelDatatable;
use App\Datatables\SystemLabelDatatable;
use App\Form\LabelType;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Datatable\DatatableInterface;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/label', name: 'admin_label_')]
class LabelController extends BaseController
{
    /**
     * @param Request $request
     * @param DatatableFactory $factory
     * @param DatatableResponse $responseService
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/custom', name: 'custom')]
    public function customLabels(
        Request $request,
        DatatableFactory $factory,
        DatatableResponse $responseService
    ): Response {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $datatable = $factory->create(CustomLabelDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        $form = $this->createForm(LabelType::class);

        return $this->render('label/custom.html.twig', [
            'datatable' => $datatable,
            'filter' => $this->filter,
            'form' => $form->createView()
            ]);
    }

    /**
     * @param Request $request
     * @param DatatableFactory $factory
     * @param DatatableResponse $responseService
     * @return Response
     * @throws \Exception
     */
    #[Route(path: '/system', name: 'system')]
    public function systemLabels(
        Request $request,
        DatatableFactory $factory,
        DatatableResponse $responseService
    ): Response {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $datatable = $factory->create(SystemLabelDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        $form = $this->createForm(LabelType::class);

        return $this->render('label/system.html.twig', [
            'datatable' => $datatable,
            'filter' => $this->filter,
            'form' => $form->createView()
        ]);
    }

}
