<?php

declare(strict_types=1);

namespace Kreyu\Bundle\DataTableBundle\Action\Type;

use Kreyu\Bundle\DataTableBundle\Action\ActionBuilderInterface;
use Kreyu\Bundle\DataTableBundle\Action\ActionInterface;
use Kreyu\Bundle\DataTableBundle\Action\ActionView;
use Kreyu\Bundle\DataTableBundle\Util\StringUtil;
use Symfony\Component\OptionsResolver\OptionsResolver;

abstract class AbstractActionType implements ActionTypeInterface
{
    public function buildAction(ActionBuilderInterface $builder, array $options = []): void
    {
    }

    public function buildView(ActionView $view, ActionInterface $action, array $options): void
    {
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
    }

    public function getBlockPrefix(): string
    {
        return StringUtil::fqcnToShortName(static::class, ['ActionType', 'Type']) ?: '';
    }

    public function getParent(): ?string
    {
        return ActionType::class;
    }
}
