<?php
$envFilepath = "../.env";

## 1. read variables from .env file
if (is_file($envFilepath)) {
	$file = new \SplFileObject($envFilepath);
	// Loop until we reach the end of the file.
	while (false === $file->eof()) {
		// Get the current line value, trim it and save by putenv.
		$line=str_replace("'", "", trim($file->fgets()));
		if (str_contains($line, '=')) {
			putenv($line);
		}
	}
}

# 2. initialize FFI - needs to be done once every PHP run
$ffi = FFI::cdef(
    file_get_contents("../libs/dwarflenc.h"),
    "../libs/libdwarflenc.so");

# 3. this is the text to be encoded
$text = "text";

# 4. encode allocating new string (encoded text) inside library - fine if not repeated a fillion times (new string not freed) and you can dealloc if needed - see below
$res = $ffi->dwarflenc_encode($ffi->DWARFLENC_MODE_RELAXED, $text, strlen($text), getenv('DWARFG_UI_SCDKEY', ''), NULL, $ffi->DWARFLENC_SALT_RANDOM, $ffi->DWARFLENC_SALT_RANDOM, $ffi->DWARFLENC_SALT_RANDOM, $ffi->DWARFLENC_VERSION_LAST);
# BEWARE that on failure, $res is NULL

# ATTENTION - getting the whole string REQUIRES to provide $res->len to the FFI::string, otherwise the string gets cut on the first zero byte !!! Also, you need to covert to string before inserting into DB.
$res_string = FFI::string($res->data, $res->len);

if (is_null($res)) {
	echo("Error from library<br>");
} else {
	echo("Library call OK, dumping structure...<br>");
	if ($res->len != strlen($text)) {
		echo("Invalid result, length does not equal text length.");
	}
	echo("Bytes: ");
	for ($y=0; $y<$res->len; $y++) {
		echo(ord($res->data[$y]) . ", ");
	}
	echo("<br> length of encoded text from library/of PHP string is: " .$res->len . "/" . strlen($res_string));
	echo("<br>Salt: ");
	var_dump($res->salt);
	echo("<br>Pepper: ");
	var_dump($res->pepper);
	echo("<br>Chilli: ");
	var_dump($res->chilli);
	echo("<br>Version: ");
	var_dump($res->version);
}

# 5. work with the data. DO NOT FORGET to store all of data, salt, pepper, chilli, version

# (optional) 6. free the allocated data - useful for long-running process or when calling encode/decode a lot
$ffi->dwarflenc_free_packed_data($res);

