<?php

declare(strict_types=1);

namespace App\Entity\ConfigProfile;

use App\Entity\Types\TypesValueType;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'config_keys')]
#[ORM\Entity]
class ConfigProfileKey
    {
    /**
     * @var int|null
     */
    #[ORM\Column(name: 'id', type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: false)]
    public string $keyName;

    /**
     * @var ConfigProfileKeyGroup
     */
    #[ORM\ManyToOne(targetEntity: ConfigProfileKeyGroup::class, inversedBy: 'configProfileKeys')]
    #[ORM\JoinColumn(name: 'group_name', referencedColumnName: 'id')]
    public ConfigProfileKeyGroup $groupName;

    /**
     * @var TypesValueType
     */
    #[ORM\ManyToOne(targetEntity: TypesValueType::class, inversedBy: 'configValueTypes')]
    #[ORM\JoinColumn(name: 'value_type', referencedColumnName: 'id')]
    public TypesValueType $valueType;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'key', targetEntity: ConfigProfileValue::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public Collection $configValues;

    /**
     * @var ConfigProfile
     */
    #[ORM\ManyToOne(targetEntity: ConfigProfile::class, inversedBy: 'configProfileKeys')]
    #[ORM\JoinColumn(name: 'id', referencedColumnName: 'id')]
    public ConfigProfile $configProfile;


    /**
     * ConfigProfile constructor
     */
    public function __construct(){

        $this->configValues = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getKeyName(): string
    {
        return $this->keyName;
    }

    /**
     * @param string $keyName
     */
    public function setKeyName(string $keyName): void
    {
        $this->keyName = $keyName;
    }

    /**
     * @return ConfigProfileKeyGroup
     */
    public function getGroupName(): ConfigProfileKeyGroup
    {
        return $this->groupName;
    }

    /**
     * @param ConfigProfileKeyGroup $groupName
     */
    public function setGroupName(ConfigProfileKeyGroup $groupName): void
    {
        $this->groupName = $groupName;
    }

    /**
     * @return TypesValueType
     */
    public function getValueType(): TypesValueType
    {
        return $this->valueType;
    }

    /**
     * @param TypesValueType $valueType
     */
    public function setValueType(TypesValueType $valueType): void
    {
        $this->valueType = $valueType;
    }

    /**
     * @return Collection<int, \App\Entity\ConfigProfile\ConfigProfileValue>
     */
    public function getConfigValues(): Collection
    {
        return $this->configValues;
    }

    /**
     * @param Collection $configValues
     */
    public function setConfigValues(Collection $configValues): void
    {
        $this->configValues = $configValues;
    }

}