<?php declare(strict_types=1);

namespace App\DataTable;

use App\Entity\AgentProfile\AgentProfile;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class AgentProfileDatatable
 * @package App\Datatables
 */
final class AgentProfileDatatable extends BaseDatatable
{

    protected string $entity = AgentProfile::class;
    protected string $name = 'agent_profile_datatable';

    /**
     * {@inheritdoc}
     * @throws \Exception
     */
    public function buildDatatable(array $options = []): void
    {

        //$userModules = $options['userModules'];

        parent::buildDatatable($options);

        $this->options->setOrder([0, 'asc']);

        $this->extensions->set([
            'buttons' => [
                'create_buttons' => [
                    [
                    'action' => [
                        'template' => '/datatable/agentProfile/createAgentProfile.js.twig',
                        'vars' => ['link' =>  $this->router->generate('admin_agent_profile_add')],
                    ],
                    'class_name' => 'btn-add',
                    'name' => 'addAgentProfile',
                    'text' => '<i class=\"fa fa-plus\"></i> Create Agent Profile',
                    ],
                    $this->getRefreshButton()
                ],
            ],
        ]);

        $this->addIdColumn();

        $this->columnBuilder
            ->add('profileName', Column::class,[
                'title' => 'Name',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('intPing', Column::class, [
                'title' => 'Ping',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('intRegular', Column::class, [
                'title' => 'Regular',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('intDebug', Column::class, [
                'title' => 'Debug',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('intFallback', Column::class, [
                'title' => 'Fallback',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('smallcycles', Column::class, [
                'title' => 'Small Cycles',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])
            ->add('connfailTolerance', Column::class, [
                'title' => 'Fail Tolerance',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => [
                    TextFilter::class, [
                        'cancel_button' => true,
                    ],
                ],
            ])

            ->add('Devices_count', Column::class, [
                'title' => 'Devices count',
                'width' => '100%;',
                //agentprofile.id on the end of the subquery must be in small case I do not know why????
                'dql' => '(SELECT COUNT({p}) FROM App\Entity\Device\Device {p} WHERE {p}.agentProfile = agentprofile.id)',
                'searchable' => false,
                'orderable' => true,
            ])
            ->add(null, ActionColumn::class, [
                'title' => $this->translator->trans('sg.datatables.actions.column_name'),
                'width' => '100%;',
                'class_name' => 'row_actions',
                'actions' => [
                    [
                        'route' => 'admin_agent_profile_edit',
                        'route_parameters' => ['profileId' => 'id'],
                        'label' => $this->translator->trans('sg.datatables.actions.edit'),
                        'icon' => self::ICON_EDIT,
                        'attributes' => [
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.edit'),
                            'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                            'role' => 'button',
                        ],
                    ],
                    [
                        'route' => 'ajax_agent_profile_delete',
                        'route_parameters' => ['agentProfileId' => 'id'],
                        'label' => $this->translator->trans('sg.datatables.actions.delete'),
                        'icon' => self::ICON_DELETE,
                        'attributes' => [
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.delete'),
                            'class' => 'btn btn-danger btn-xs mb-1',
                            'role' => 'button',
                            'data-toggle' => 'modal',
                            'id' => 'delete',
                            'data-target' => "#confirm-delete",
                        ],
                        'render_if' => function ($row) {
                            return $row['id'] !== 1 && $row['id'] !== 2 && $row['id'] !== 3 &&
                                $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },
                        'end_html' => '</div>',
                    ],
                ],
            ])

        ;
    }

}