<?php

namespace App\Form\Device;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DeviceNetDevicesType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $netDevices = $options['data']['netDevices'];

        foreach ($netDevices as $netDevice){

            $builder
                ->add('cellular_' . $netDevice->getId(), CheckboxType::class, array(
                    'required' => false,
                    'label' => false,
                    'data' => ($netDevice->isCellular) ? true : false,
                ))
                ->add('linkable_' . $netDevice->getId(), CheckboxType::class, array(
                    'required' => false,
                    'label' => false,
                    'data' => ($netDevice->isLinkable) ? true : false,
                ));

        }

        $builder
            ->add('save', SubmitType::class, [
				'label' => '<i class="fas fa fa-refresh"></i> Update Settings',
				'label_html' => true,
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
    {

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}