<?php

namespace App\Repository;

use App\Entity\ConfigProfile\ConfigProfile;
use App\Entity\Device\Device;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\DBAL\ArrayParameterType;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method ConfigProfile|null find($id, $lockMode = null, $lockVersion = null)
 * @method ConfigProfile|null findOneBy(array $criteria, array $orderBy = null)
 * @method ConfigProfile[]    findAll()
 * @method ConfigProfile[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ConfigProfileRepository extends ServiceEntityRepository
{

    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry){

        parent::__construct($registry, ConfigProfile::class);

    }

    /**
     * @param Device $device
     * @return float|int|mixed|string
     */
    public function getDevicesToBeClonedFrom(Device $device): mixed
	{

        return $this->createQueryBuilder('p')
            ->where('p.automatic is not null')
            ->andWhere('p.automatic != :val')
            ->setParameter('val', $device)
            ->getQuery()
            ->getResult()
            ;

    }

	/**
	 * @param array $deviceIds
	 * @param int $devTypeId
	 * @return array
	 * @throws \Doctrine\DBAL\Exception
	 */
    public function getDevicesToBeClonedFromPlainSql(array $deviceIds, int $devTypeId): array {

        $conn = $this->getEntityManager()->getConnection();

        $sql = '
            SELECT cp.id, cp.automatic, d.devid, d.name FROM config_profiles as cp
                    left join devices as d on d.id_device = cp.automatic
            WHERE cp.automatic is not null AND cp.automatic not IN(:deviceIds) AND d.dev_type = :devTypeId AND d.deleted = 0
            ';

        return $conn->executeQuery(
			$sql,
			['deviceIds' => $deviceIds, 'devTypeId' => $devTypeId],
			['deviceIds' =>  ArrayParameterType::INTEGER ]
		)->fetchAllAssociative();

    }

	public function getProfilesToMakeCopy(): array
	{

		$conn = $this->getEntityManager()->getConnection();

		$sql = '
            SELECT id, name FROM config_profiles
        	WHERE directive is not null AND deleted = 0
            ';

		return $conn->executeQuery(
			$sql,
		)->fetchAllAssociative();

	}

}
