<?php

namespace App\Form\ConfigProfile;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class ConfigProfileFileUploadConfirmType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

		$profileData = $options['data']['profileData'] ?? '';

        $builder

			->add('profileData', HiddenType::class, [
				'data' => $profileData
			])

			->add('upload', SubmitType::class, [
				'label' => '<i class="fa fa-check" aria-hidden="true"></i> Update all Profile data',
				'label_html' => true,
				'block_prefix' => 'form_footer',
			]);
    }
}
